/**
* \file: Statistics.h
*
* \version: $Id:$
*
* \release: $Name:$
*
* <brief description>.
* <detailed description>
* \component: CarPlay
*
* \author: J. Harder / ADIT/SW1 / jharder@de.adit-jv.com
*
* \copyright (c) 2013-2014 Advanced Driver Information Technology.
* This code is developed by Advanced Driver Information Technology.
* Copyright of Advanced Driver Information Technology, Bosch, and DENSO.
* All rights reserved.
*
* \see <related items>
*
* \history
*
***********************************************************************/

#ifndef CARPLAY_STATISTICS_H
#define CARPLAY_STATISTICS_H

#include <stdio.h>
#include <string>
#include <list>
#include <pthread_adit.h>

namespace adit { namespace carplay
{

class IStatisticsProvider
{
public:
    virtual std::list<std::string> GetStatistics() = 0;
};

enum AVChannel
{
    AVChannel_MainAudio = 0,
    AVChannel_AltAudio = 1,
    AVChannel_Video = 2,

    AVChannel_Count = 3
};

class Statistics
{
public:
    static Statistics& Instance() { return singleton; }

    void SetDeviceID(const std::string& inDeviceID);
    void AddServer(const std::string& inConfigFile, IStatisticsProvider& inConfig);
    void RemoveServer();

    void AddSession(void* inSession);
    void RemoveSession(void* inSession);
    void SetLatestModeChange(void* inSession, const std::string& inModeChange);
    void SetAVChannel(void* inSession, AVChannel inChannel, bool inActive);

    void DumpStatistics();

    inline uint32_t GetSessionCount() { return sessionCount; }

private:
    static Statistics singleton;
    pthread_mutex_t lock;

    // global
    std::string deviceID;
    uint32_t serverCount;
    std::string configFile;
    IStatisticsProvider* config;

    // session-based
    struct SessionStatistics
    {
        std::string modeChange;
        bool active[AVChannel_Count];
    };

    uint32_t sessionCount;
    SessionStatistics sessionStatistics;

    Statistics();

    void dumpToFile(FILE* inFile);
};

} } /* namespace adit { namespace carplay */

#endif /* CARPLAY_STATISTICS_H */
